import React, { Component } from 'react';
import { FlatList, Text } from 'react-native';
import PeopleListItem from './PeopleListItem';
class PeopleList extends Component {
    constructor(props) {
        super(props);
    }
    handleClick = name => {
        this.props.deleteItem(name);
    };
    render() {
        const people = this.props.listOfItems;
        return (
            <FlatList
                data={people}
                keyExtractor={item => item.id}
                renderItem={({ item }) => (
                    <PeopleListItem key={item.id} name={item.name} job={item.job} handleClick={this.handleClick} />
                )}
            />
        );
    }
}
export default PeopleList;
